<%@ Language="C#" Inherits="Coveo.SearchProvider.Applications.Admin.CoveoDiagnosticPage" CodeBehind="CoveoDiagnosticPage.aspx.cs" AutoEventWireup="True" EnableSessionState="false" MaintainScrollPositionOnPostback="true"%>
<%@ Import Namespace="Sitecore.Data.Items" %>

<%@ Register tagPrefix="coveo" tagName="CloudFieldStatistics" src="Controls/CloudFieldStatistics.ascx" %>
<%@ Register tagPrefix="coveo" tagName="OrganizationDocumentUsageStatistics" src="Controls/OrganizationDocumentUsageStatistics.ascx" %>

<%-- NOTE: When making changes to this file, verify if another copy exists for a specific Sitecore version 
    (see Serialized\Sitecore*\Files\sitecore modules\Web\Coveo\Admin\CoveoDiagnosticPage.aspx). --%>

<!DOCTYPE html>
<html>
<head>
    <title>Coveo for Sitecore components state</title>
    <link rel="shortcut icon" type="image/png" href="images/favicon.ico"/>
    <link href="css/CoveoDiagnosticPage.css" rel="stylesheet" type="text/css"/>
    <script type="text/javascript" src="https://code.jquery.com/jquery-3.5.0.min.js"></script>
    <script type="text/javascript" src="js/toggleErrorDetails.js"></script>
</head>
<body>
<div class="main-div">
    <form runat="server">
        <h1>Coveo for Sitecore components state</h1>
        <div class="refresh-container">
            <asp:Button Text="Download Diagnostic Package" ID="DownloadDiagnosticPackage" class="toolbar-button downloadpackage-button" runat="server"></asp:Button>

            <p class="refresh-text">To see if any state has changed:</p>
            <asp:Button Text="Refresh" value="Refresh" id="RefreshButton" class="toolbar-button reload-button" runat="server" OnClick="HandleRefreshButtonClick"/>
        </div>
        <div class="component-state-container">
            <div id="TroubleshootingPanel" class="info-panel" runat="server">
                Please refer to Coveo's <asp:HyperLink ID="TroubleshootingGuideLink" Target="_blank" runat="server">Troubleshooting Guide</asp:HyperLink> to solve the errors displayed below.
            </div>
            <asp:Repeater ID="StateRepeater" ItemType="Coveo.SearchProvider.Applications.VerificationResponse" runat="server">
                <HeaderTemplate>
                    <table cellspacing="0" class="coveo-states">
                    <thead>
                    <tr>
                        <th>Component Name</th>
                        <th>State</th>
                    </tr>
                    </thead>
                    <tbody>
                </HeaderTemplate>
                <ItemTemplate>
                    <tr>
                        <td class="status-component-name"><%#: Item.ComponentName %></td>
                        <td class="<%#: Item.StyleClass %>">
                            <div class="status-icon"></div>
                            <div class="status-message">
                                <asp:Label ID="Message" runat="server" Text='<%# Item.Message %>'/>
                                <asp:PlaceHolder ID="ShowMoreDetails" Visible="<%# !String.IsNullOrEmpty(Item.ErrorDetails) %>" runat="server">
                                    <a class="search-error-button" href="https://connect.coveo.com/s/global-search/%40uri#q=<%# Item.SearchContent %>" target="_blank">
                                        <img src="images/help.png" alt="Search for information on search.coveo.com"/>
                                    </a>
                                    <a class="show-details-button" onclick="toggleErrorDetails(this, '<%# Container.FindControl("ShowMoreDetails").ClientID %>_ErrorDetails');">Show details</a>
                                    <div id="<%#: Container.FindControl("ShowMoreDetails").ClientID %>_ErrorDetails" style="display: none;">
                                        <code>
                                            <pre><%#: Item.ErrorDetails %></pre>
                                        </code>
                                    </div>
                                </asp:PlaceHolder>
                            </div>
                        </td>
                    </tr>
                </ItemTemplate>
                <FooterTemplate>
                    </tbody>
                    </table>
                </FooterTemplate>
            </asp:Repeater>
        </div>
        <h1>Coveo for Sitecore version information</h1>
        <div class="version-container">
            <asp:PlaceHolder ID="VersionCompatibilitySection" runat="server">
                <p>Current Coveo for Sitecore version: <asp:Label ID="CoveoForSitecoreVersion" runat="server"/>
                </p>
                <p>Current Sitecore version: <asp:Label ID="CurrentSitecoreVersion" runat="server"/>
                </p>
                <p>Compatibility status: <asp:Label ID="VersionCompatibilityStatus" runat="server"/>
                </p>
            </asp:PlaceHolder>
            <asp:Label ID="VersionCompatibilityErrorMessage" Visible="false" runat="server"/>
        </div>
        <h1>Coveo for Sitecore organization information</h1>
        <div class="version-container">
            <asp:PlaceHolder ID="CloudInformationSection" runat="server">
                <asp:HyperLink ID="CloudPlatformUrl" runat="server" target="_blank">Open Cloud Administration Console</asp:HyperLink>
                <asp:Label ID="CloudPlatformUrlErrorMessage" Visible="false" runat="server"/>
                <p class="current-organization">Current Coveo Cloud organization name: <asp:Label ID="CloudOrganizationName" class="coveo-emphasized-text" runat="server"/>
                </p>
                <p>Current Coveo Cloud organization ID: <asp:Label ID="CloudOrganizationId" class="coveo-emphasized-text" runat="server"/>
                </p>
                <asp:Label ID="CloudOrganizationErrorMessage" Visible="false" runat="server"/>
                <p>
                    <asp:PlaceHolder ID="CloudFieldUsageSection" runat="server">
                        Field usage:
                        <coveo:CloudFieldStatistics ID="CloudFieldUsage" runat="server"/>
                    </asp:PlaceHolder>
                </p>
                <p>
                    <asp:PlaceHolder ID="OrganizationDocumentUsageSection" Visible="False" runat="server">
                        Documents usage:
                        <coveo:OrganizationDocumentUsageStatistics ID="OrganizationDocumentUsage" runat="server"/>
                    </asp:PlaceHolder>
                </p>
            </asp:PlaceHolder>
        </div>
        <h1>Coveo for Sitecore configuration files</h1>
        <div class="config-container">
            <asp:PlaceHolder ID="MissingCoveoConfigFilesSection" runat="server">
                <asp:Repeater ID="MissingCoveoConfigRepeater" runat="server">
                    <HeaderTemplate>
                        Missing Coveo configuration Files:
                    </HeaderTemplate>
                    <ItemTemplate>
                        <p class="config-file missing"><%# Container.DataItem %></p>
                    </ItemTemplate>
                    <FooterTemplate>
                    </FooterTemplate>
                </asp:Repeater>
            </asp:PlaceHolder>
        </div>
        <div class="config-container">
            <asp:PlaceHolder ID="LoadedConfigFilesSection" runat="server">
                <asp:Repeater ID="ConfigRepeater" runat="server">
                    <HeaderTemplate>
                        Currently loaded Coveo configuration files (configuration files that contains Coveo in the name):
                    </HeaderTemplate>
                    <ItemTemplate>
                        <p class="config-file"><%# Container.DataItem %></p>
                    </ItemTemplate>
                    <FooterTemplate>
                    </FooterTemplate>
                </asp:Repeater>
            </asp:PlaceHolder>
            <asp:Label ID="LoadedConfigFilesErrorMessage" Visible="false" runat="server"/>
        </div>
        <h1>Coveo for Sitecore published items</h1>
        <div class="publish-container">
            <asp:PlaceHolder ID="PublishedItemsSection" runat="server">
                <p>Published status: <asp:Label ID="PublishedItemsStatus" runat="server"/>
                </p>
            </asp:PlaceHolder>
            <asp:Label ID="PublishedItemsErrorMessage" Visible="false" runat="server"/>
            <asp:Button ID="ViewPublishedItemsButton" class="index-button" Visible="false" runat="server" onclick="HandleViewPublishedItemsButtonClick"/>
            <asp:Repeater ID="PublishedItemsRepeater" Visible="false" ItemType="Coveo.SearchProvider.Applications.Admin.CoveoItemPublishedStatus" runat="server">
                <HeaderTemplate>
                    <table cellspacing="0" class="coveo-states published-items">
                    <thead>
                    <tr>
                        <th>Item path</th>
                        <th ID="PublishedItemsDatabaseHeaderColumn" runat="server">Database: <asp:Label ID="PublishedItemsDatabaseName" runat="server"/></th>
                        <th ID="PublishedItemsContentDatabaseHeaderColumn" runat="server">Content Database: <asp:Label ID="PublishedItemsContentDatabaseName" runat="server"/></th>
                    </tr>
                    </thead>
                    <tbody>
                </HeaderTemplate>
                <ItemTemplate>
                    <tr>
                        <td><%#: Item.Path %></td>
                        <td ID="IsPublishedInDatabaseColumn" class="<%#: Item.DatabaseStyleClass %>" Visible="<%# Item.IsPublishedInDatabase.HasValue %>" runat="server">
                            <div class="status-icon"></div>
                            <div class="status-message">
                                <asp:Label ID="IsPublishedInDatabase" runat="server" Text='<%# Item.IsPublishedInDatabase %>'/>
                            </div>
                        </td>
                        <td ID="IsPublishedInContentDatabaseColumn" class="<%#: Item.ContentDatabaseStyleClass %>" Visible="<%# Item.IsPublishedInContentDatabase.HasValue %>" runat="server">
                            <div class="status-icon"></div>
                            <div class="status-message">
                                <asp:Label ID="IsPublishedInContentDatabase" runat="server" Text='<%# Item.IsPublishedInContentDatabase %>'/>
                            </div>
                        </td>
                    </tr>
                </ItemTemplate>
                <FooterTemplate>
                    </tbody>
                    </table>
                </FooterTemplate>
            </asp:Repeater>
        </div>
        <h1>Coveo for Sitecore indexing test</h1>
        <div class="index-container">
            <asp:PlaceHolder ID="IndexingTestSection" runat="server">
                <table cellspacing="0" class="coveo-states">
                    <thead>
                    <tr>
                        <th>Try indexing:</th>
                        <th>Result</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>
                            <asp:DropDownList ID="IndexNamesDropDownList" runat="server"></asp:DropDownList>
                            <asp:TextBox ID="ItemPathTextBox" Width="300px" runat="server"></asp:TextBox>
                            <asp:Button text="Index" value="Index" id="IndexButton" class="index-button" runat="server" onclick="HandleIndexButtonClick"/>
                        </td>
                        <td runat="server" ID="IndexingResultContainer">
                            <div class="status-icon"></div>
                            <div class="status-message">
                                <asp:Literal ID="IndexingResult" runat="server"></asp:Literal>
                            </div>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </asp:PlaceHolder>
            <asp:Label ID="IndexingTestErrorMessage" Visible="false" runat="server"/>
        </div>
        <h1>Coveo for Sitecore log viewer</h1>
        <div class="log-container">
            <asp:PlaceHolder ID="LogViewerSection" runat="server">
                <div>
                    <asp:DropDownList ID="LogFilesList" runat="server"></asp:DropDownList>
                    <asp:Button text="View Log" value="ViewLog" id="ViewLogButton" class="index-button" runat="server" onclick="HandleViewLogButtonClick"/>
                    <div class="log-box">
                        <asp:Literal id="LogContent" runat="server"/>
                    </div>
                </div>
            </asp:PlaceHolder>
            <asp:Label ID="LogViewerErrorMessage" Visible="false" runat="server"/>
        </div>
        <h1>Indexes List</h1>
        <div class="index-list-container">
            <asp:PlaceHolder ID="IndexListSection" runat="server">
                 <asp:Repeater ID="IndexList" ItemType="Coveo.SearchProvider.Applications.Admin.IndexDetails" runat="server">
                    <HeaderTemplate>
                        <table cellspacing="0" class="coveo-states">
                        <thead>
                        <tr>
                            <th>Name</th>
                            <th class="is-coveo-column">Is Coveo</th>
                            <th>Type</th>
                            <th>Assembly Location</th>
                        </tr>
                        </thead>
                        <tbody>
                    </HeaderTemplate>
                    <ItemTemplate>
                        <tr>
                            <td><%#: Item.Name %></td>
                            <td class="is-coveo-column"><%#: Item.IsCoveo %></td>
                            <td><%#: Item.Type %></td>
                            <td><%#: Item.AssemblyLocation %></td>
                        </tr>
                    </ItemTemplate>
                    <FooterTemplate>
                        </tbody>
                        </table>
                    </FooterTemplate>
                </asp:Repeater>
            </asp:PlaceHolder>
            <asp:Label ID="IndexListErrorMessage" Visible="false" runat="server"/>
            <asp:Label ID="NoIndexInListErrorMessage" class="error" Visible="false" runat="server">
                No indexes detected
                <a class="search-error-button" href="https://docs.coveo.com/en/2148/coveo-for-sitecore-v5/an-index-should-be-configured-for-database-web-error-is-preventing-the-rest-service-from-loading" target="_blank">
                    <img src="images/help.png" alt="Search for information on search.coveo.com"/>
                </a>
            </asp:Label>
        </div>
    </form>
    <div class="logo-footer"></div>
</div>
</body>
</html>